<?php
/**
 * Main Page
 *
 * @package     Wow_Plugin
 * @subpackage  Wow-Company/Main
 * @author      Wow-Company <givememony1982@gmail.com>
 * @copyright   2019 Wow-Company (Wow-Company)
 * @license     GNU Public License
 * @version     0.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$logo = plugin_dir_url( __FILE__ ) . 'image/icon.png';
?>

<div class="wrap full-width-layout wow-page">
    <div class="about-wrap">

        <h1>Welcome</h1>

        <p class="about-text">
            Congratulations! You are about to use one of our plugins. </p>

        <div class="wow-badge" style="display: none;">
            <img src="<?php echo esc_url( $logo ); ?>">
        </div>

    </div>

    <div class="about-wrap">

        <p>Since June 2016, we write <strong>plugins</strong> for websites running on the <strong>WordPress</strong>
            platform.</p>

        <p>In the beginning, Wow-Company was more like a hobby, uniting friends. The more time and efforts were invested
            in cooperation – the more obvious it became to us an opting for full focus on the project. When we finished
            the first plugin for <strong>WordPress sites,</strong> received satisfaction from a well-done job and
            positive customer reviews confirmed our intention to continue the work.</p>

        <h3>Principles and attitude to work.</h3>
        <p>We constantly come up with new concepts, prototype them, and test them. We launch the development of three
            types of projects:</p>

        <ul>
            <li>have obvious practical benefits;</li>
            <li>offer a unique experience for the site visitor;</li>
            <li>contain a unique set of tools for webmasters.</li>
        </ul>

        <p><strong>Creating a plugin for WordPress</strong> requires a lot of time and effort. The plugin is not issued
            unless the verification of its work correctness has been done. After the release, we constantly interact
            with the user community and provide free technical and informational support for customers, who have
            purchased the plugin’s full version. If anyone has a problem – everything possible is done to solve it
            quickly. Our products are kept updated and adjusted to the new versions of the WordPress platform.</p>

        <h3>The benefits of the Wow-Company solutions.</h3>

        <p>The main feature of our plugins – is the simplicity of their capabilities mutual alignment and embedding into
            systems that use other developers’ plugins.</p>

        <p>To install and configure <strong>the Wow-Company WordPress plugins</strong> a minimum of skills is needed. We
            create an intuitive interface with an informative description of the available options – they are simple to
            navigate and configure the plugins work as required.</p>

        <p>Download Wow-Company’s<strong> WordPress plugins</strong> and evaluate their usability by yourself.</p>


    </div>

    <div class="wow-page-content">
		<?php include( 'wow-plugins.php' ); ?>
    </div>

</div>


